/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.fw.ui.UIObjectsConstants;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

class UIObjectsOffsets
implements UIObjectsConstants {
    private RandomAccessFile objectsReader;
    private Map recordOffsets;
    private static final String TRACE_MASKT = "HUIOBJOT";
    private static final String TRACE_MASKF = "HUIOBJOF";
    private static final String TRACE_MASKD = "HUIOBJOD";

    UIObjectsOffsets(RandomAccessFile objectsReader) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsOffsets.UIObjectsOffsets()");
        this.objectsReader = objectsReader;
        this.recordOffsets = new HashMap();
        Trace.trace(TRACE_MASKF, "<- UIObjectsOffsets.UIObjectsOffsets()");
    }

    int getOffset(String shortId) throws IOException {
        int result = -1;
        Integer offset = (Integer)this.recordOffsets.get(shortId);
        if (offset == null) {
            byte[] shortIdBytes = shortId.getBytes();
            int numRecords = (int)(this.objectsReader.length() / 769L);
            byte[] buffer = new byte[8];
            for (int i = 0; i < numRecords && result == -1; ++i) {
                this.objectsReader.seek(i * 769);
                this.objectsReader.read(buffer, 0, 8);
                boolean match = true;
                for (int j = 0; j < 8 && match; ++j) {
                    if (shortIdBytes[j] == buffer[j]) continue;
                    match = false;
                }
                if (!match) continue;
                result = i * 769;
                this.recordOffsets.put(shortId, new Integer(result));
            }
        } else {
            result = offset;
        }
        if (result == -1) {
            throw new InvalidIdException("Could not find shortId [" + shortId + "] in the objects file.");
        }
        return result;
    }

    void add(String shortId, int offset) {
        this.recordOffsets.put(shortId, new Integer(offset));
    }

    boolean isOffsetKnown(String shortId) {
        return this.recordOffsets.get(shortId) != null;
    }
}

